using System;
using System.Data;
using System.Data.SqlClient;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>John Vrooland</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>05/30/2003</CreationDate>
	///<Note>Note: The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access layer class implementing database read/write 
	///	functionality for component class related data.
	///</summary>

	
	public class ComponentClass
	{
        
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1154"> 
		///		<ExpectedInput>ComponentClass ID</ExpectedInput>
		///		<ExpectedOutput>DataTable of ComponentClass Details</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1156"> 
		///		<ExpectedInput>Invalid Id</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>Retrieves single component class data by its ID</summary>
		///<param name="componentClassId">Component class ID</param>
		///<returns>DataTable containing a single row with component class data</returns>
		public static DataTable GetComponentClassFromId(int componentClassId)
        {
            SqlParameter[] _prms =
            {
                new SqlParameter(STOREDPROC.GetComponentClassFromId.componentclassid, SqlDbType.Int)
            };

			_prms[0].Value = componentClassId;
            
            return Common.StoredProcedure.GetData(STOREDPROC.GetComponentClassFromId.StoredProcName, _prms).Tables[0];

        }
	}
}
